#-----------------------------------------------------------------------------
# Anaglyph
# 2/3/05
# Copyright (c) 2005 by David G. Drumright (ockham)
#-----------------------------------------------------------------------------
# Modified by Bill Underwood (underdog)
#   Changed to not call Action method until they click the Show button.
#   Added a mouse click event to START the Out.BMP file with whatever you
#     have associated with the BMP suffix on your box.
#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
import poser
import os
import sys
import string
scene = poser.Scene()

BasePathUncut = poser.AppLocation()  # So we can strip off the full paths given by tkFileDialog
BasePath = BasePathUncut[:(-len('poser.exe'))]

ScriptLocation = os.path.abspath(os.path.join(BasePath,'runtime/Python/poserScripts/Anaglyph'))

# Put BMPs in folder under script path
BMPLocation=os.path.join(ScriptLocation,'Outputs')
# If dir already made, ignore error.
try:
    os.mkdir(BMPLocation)
except:
    pass

RedName=os.path.normpath(os.path.join(BMPLocation,"Red.BMP"))
GrnName=os.path.normpath(os.path.join(BMPLocation,"Grn.BMP"))
OutName=os.path.normpath(os.path.join(BMPLocation,"Out.BMP"))

WINSIZE=400

#-----------------------------------------------------------------------------

# Get the PYD
if float(poser.Version()) < 5.0:
    import _Anaglyphmodule15
    Mix = _Anaglyphmodule15.Mix
    ShowBMP = _Anaglyphmodule15.ShowBMP
else:
    import _Anaglyphmodule22
    Mix = _Anaglyphmodule22.Mix
    ShowBMP = _Anaglyphmodule22.ShowBMP

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Anaglyph")


        self.PicFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.PicFrame.grid(row=0,column=0)
        self.ButFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ButFrame.grid(row=1,column=0)

        self.Pic = Canvas(self.PicFrame,  width=WINSIZE,height=WINSIZE,bg="white",borderwidth=2,relief=RIDGE)
        self.Pic.grid(row=1,column=0)
        self.Pic.bind("<Button-1>", self.HandlePicClick)

        self.buttonGo = Button(self.ButFrame, text="Show", command=self.HandleGo)
        self.buttonGo.grid(row=0, column=0, padx=10)

        self.buttonLeftAdj = Button(self.ButFrame, text="<", command=self.HandleLeftAdj)
        self.buttonLeftAdj.grid(row=0, column=1, padx=10)

        self.Show = Entry(self.ButFrame, width=6)
        self.Show.grid(row=0, column=2, padx=10)
        self.Show.bind("<Return>",self.HandleEntry)

        self.buttonRightAdj = Button(self.ButFrame, text=">", command=self.HandleRightAdj)
        self.buttonRightAdj.grid(row=0, column=3, padx=10)

        self.buttonCancel = Button(self.ButFrame, text="Cancel", command=self.HandleCancel)
        self.buttonCancel.grid(row=0, column=4, padx=10)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)

        # Make Aux cam equal Main cam:
        MCam=scene.Actor("Main Camera")
        ACam=scene.Actor("Aux Camera")
        for MP in MCam.Parameters():
            AP=ACam.Parameter(MP.Name())
            AP.SetValue(MP.Value())

        scene.SetRenderToNewWindow(0) # Be sure we render to the preview window
        self.ShowCam()

    # - - - - - - - - - - - - - - - - - -

    def HandlePicClick(self, val):
        os.system('start Runtime\Python\poserScripts\Anaglyph\Outputs\Out.BMP')

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents()
        root.lift()
        root.after(100, self.Update)

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def HandleLeftAdj(self):
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(P.Value()-0.1)
        self.ShowCam()

    # - - - - - - - - - - - - - - - - - -

    def HandleRightAdj(self):
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(P.Value()+0.1)
        self.ShowCam()

    # - - - - - - - - - - - - - - - - - -
    def HandleEntry(self,event):
        st=event.widget.get()
        if not st: return
        else:      Val=float(st)
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(Val)
        self.ShowCam()


    # - - - - - - - - - - - - - - - - - -

    def HandleGo(self):
        self.Action()

    # - - - - - - - - - - - - - - - - - -

    def ShowCam(self):                # Show the cam angle
        global MCam, ACam
        MCam=scene.Actor("Main Camera")
        MP=MCam.ParameterByCode(poser.kParmCodeYROT)
        ACam=scene.Actor("Aux Camera")
        AP=ACam.ParameterByCode(poser.kParmCodeYROT)
        self.Show.delete(0,END)
        self.Show.insert(0,str(AP.Value()))

    def Action(self):
        global MCam, ACam, OutName, GrnName, RedName
        self.ShowCam()

        scene.SetCurrentCamera(MCam)
        #scene.DrawAll()
        scene.Render()
        scene.SaveImage("bmp",RedName)

        scene.SetCurrentCamera(ACam)
        #scene.DrawAll()
        scene.Render()
        scene.SaveImage("bmp",GrnName)


        # Next comes the mixing
        Mix(RedName, GrnName, OutName)

        # Now show the result
        TKHwnd = self.Pic.winfo_id()
        ShowBMP(TKHwnd,OutName,0,0,WINSIZE,WINSIZE)


    # - - - - - - - - - - - - - - - - - -

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
